<?php

require('routeros_api.class.php');
require('mikrotik_profil.php');

$API = new RouterosAPI();

$API->debug = false;

function addIPToMonitoring($API, $ip, $comment) {
    $API->write('/tool/netwatch/add', false);
    $API->write('=host=' . $ip, false);
    $API->write('=interval=10s', false);
    $API->write('=timeout=5s', false);
    $API->write('=down-script=/log info message=("Host ' . $ip . ' is down")', false);
    $API->write('=up-script=/log info message=("Host ' . $ip . ' is up")', false);
    $API->write('=comment=' . $comment);
    return $API->read();
}

function deleteHost($API, $id) {
    $api = $API->comm("/tool/netwatch/remove", array(
        'numbers' => $id
    ));
    
    return $api;
}

function getActiveHotspotUsers($API) {
    $API->write('/ip/hotspot/active/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);

    return count($ARRAY);
}

function deleteIPFromMonitoring($API, $id) {
    $API->write('/tool/netwatch/remove', false);
    $API->write('=numbers=' . $id);
    $API->read();
}

function getCPUStatus($API) {
    $API->write('/system/resource/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);

    if (!empty($ARRAY)) {
        return $ARRAY[0]['cpu-load'];
    } else {
        return 'N/A';
    }
}

$apData = array();
$activeAPCount = 0;
$inactiveAPCount = 0;

if ($API->connect($ipMikrotik, $username, $password)) {
    if (isset($_POST['submit'])) {
        $ip = $_POST['ip'];
        $comment = $_POST['comment'];
        $exec = addIPToMonitoring($API, $ip, $comment);
        
        if (!isset($exec['!trap'])) {
            echo "<script>alert('Berhasil ditambah');location.href='index.php';</script>";
        } else {
            echo "<script>alert('Gagal ditambah');location.href='index.php'</script>";
        }
    }
    
    if (isset($_GET['hapus'])){
        $id = $_GET['hapus'];
        $exec = deleteHost($API, $id);
        
        if (!isset($exec['!trap'])) {
            echo "<script>alert('Berhasil dihapus');location.href='index.php';</script>";
        } else {
            echo "<script>alert('Gagal dihapus');location.href='index.php'</script>";
        }
    }
    
    $API->write('/tool/netwatch/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);

    $activeUsers = getActiveHotspotUsers($API);
    $cpuStatus = getCPUStatus($API);

    foreach ($ARRAY as $item) {
        $name = (!empty($item['comment'])) ? $item['comment'] : 'Nama AP belum diisikan';

        $apData[] = array(
            'name' => $name,
            'ip' => $item['host'],
            'status' => ($item['status'] == 'up') ? 'Online' : 'Offline',
            'id' => $item['.id']
        );
    }

    foreach ($ARRAY as $item) {
        $name = (!empty($item['comment'])) ? $item['comment'] : 'Nama AP belum diisikan';

        if ($item['status'] == 'up') {
            $activeAPCount++;
        } else {
            $inactiveAPCount++;
        }
    }

    $API->disconnect();
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>FIZNET - MONITORING JARINGAN</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
<!-- Untuk matikan Load otomatis pada halamannya bisa hapus tag script ini
    <script>
        setInterval(function() {
            location.reload();
        }, 5000);
    </script>
 -->
</head>
<body class="dark-mode">
    <div class="container">
        <div class="form-container">
    <!-- Nama "NetworkSentinel" Tolong Jangan diubah-ubah -->
            <h2>--- FIZNET MONITORING ---</h2>
            <div style="display: flex; align-items: center; justify-content: center;  gap: 0;">
                <div class="kotak">
                    <div class="active-users-count"><?php echo $activeUsers; ?></div>
                    <div class="active-users-label">Hotspot Online</div>
                </div>
                <div class="kotak2">
                    <div class="up-ap-count"><?php echo $activeAPCount; ?></div>
                    <div class="up-ap-label">Pelanggan On</div>
                </div>
                <div class="kotak3">
                    <div class="down-ap-count"><?php echo $inactiveAPCount; ?></div>
                    <div class="down-ap-label">Pelanggan Off</div>
                </div>
                <div class="kotak4">
                    <div class="cpu-status-count"><?php echo $cpuStatus; ?>%</div>
                    <div class="cpu-status-label">Cpu</div>
                </div>
            </div>
        </div>
        <div class="form-container">
            <h1>Tambah Pelanggan</h1>
            <form action="" method="post">
                <input type="text" name="ip" style="margin-right: 5px; margin-left: 5px;" placeholder="Alamat IP">
                <input type="text" name="comment" style="margin-right: 5px; margin-left: 5px;" placeholder="Komentar">
                <input type="submit" name="submit" style="margin-right: 5px; margin-left: 5px;" value="Tambah">
            </form>
        </div>
        <div class="table-container">
            <h1>Daftar Pelanggan</h1>
            <?php if (!empty($apData)) { ?>
                <table>
                    <thead>
                        <tr>
                            <th>Nama Pelanggan</th>
                            <th>Alamat IP</th>
                            <th>Status</th>
                            <!--<th style="text-align:center">Aksi</th>-->
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($apData as $ap) { ?>
                            <tr>
                                <td><?php echo $ap['name']; ?></td>
                                <td><a style="color: white;" href="http://<?= $ap['ip']; ?>" target="_blank"><?= $ap['ip']; ?></a></td>
                                <td class="<?php echo ($ap['status'] == 'Online') ? 'status-up' : 'status-down'; ?>"><?php echo $ap['status']; ?></td>
                                
                                <!--<td style="text-align:center;">
                                    <a href="?hapus=<?= $ap['id']; ?>" onclick="return confirm('Yakin hapus ?')" style="color: yellow;">Hapus</a>
                                </td> -->
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            <?php } else { ?>
                <p class="no-data">Jaringan down, tidak ada data yang ditemukan.</p>
            <?php } ?>
        </div>
    </div>
</body>
</html>

    <!-- Nama "NetworkSentinel" Tolong Jangan diubah-ubah -->
