<?php
require('routeros_api.class.php');
require('mikrotik_profil.php');

$API = new RouterosAPI();
$API->debug = false;

function addIPToMonitoring($API, $ip, $comment) {
    $API->write('/tool/netwatch/add', false);
    $API->write('=host=' . $ip, false);
    $API->write('=interval=10s', false);
    $API->write('=timeout=5s', false);
    $API->write('=down-script=/log info message=("Host ' . $ip . ' is down")', false);
    $API->write('=up-script=/log info message=("Host ' . $ip . ' is up")', false);
    $API->write('=comment=' . $comment);
    return $API->read();
}

function deleteHost($API, $id) {
    return $API->comm("/tool/netwatch/remove", ['numbers' => $id]);
}

function getActiveHotspotUsers($API) {
    $API->write('/ip/hotspot/active/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);
    return count($ARRAY);
}

function deleteIPFromMonitoring($API, $id) {
    $API->write('/tool/netwatch/remove', false);
    $API->write('=numbers=' . $id);
    $API->read();
}

function getCPUStatus($API) {
    $API->write('/system/resource/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);
    return (!empty($ARRAY)) ? $ARRAY[0]['cpu-load'] : 'N/A';
}

$apData = [];
$activeAPCount = 0;
$inactiveAPCount = 0;

if ($API->connect($ipMikrotik, $username, $password)) {
    if (isset($_POST['submit'])) {
        $ip = $_POST['ip'];
        $comment = $_POST['comment'];
        $exec = addIPToMonitoring($API, $ip, $comment);

        if (!isset($exec['!trap'])) {
            echo "<script>alert('Berhasil ditambah');location.href='index.php';</script>";
        } else {
            echo "<script>alert('Gagal ditambah');location.href='index.php'</script>";
        }
    }

    if (isset($_GET['hapus'])){
        $id = $_GET['hapus'];
        $exec = deleteHost($API, $id);
        
        if (!isset($exec['!trap'])) {
            echo "<script>alert('Berhasil dihapus');location.href='index.php';</script>";
        } else {
            echo "<script>alert('Gagal dihapus');location.href='index.php'</script>";
        }
    }

    $API->write('/tool/netwatch/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);

    $activeUsers = getActiveHotspotUsers($API);
    $cpuStatus = getCPUStatus($API);

    foreach ($ARRAY as $item) {
        $name = (!empty($item['comment'])) ? $item['comment'] : 'Nama AP belum diisikan';
        $apData[] = [
            'name' => $name,
            'ip' => $item['host'],
            'status' => ($item['status'] == 'up') ? 'Online' : 'Offline',
            'id' => $item['.id']
        ];

        if ($item['status'] == 'up') {
            $activeAPCount++;
        } else {
            $inactiveAPCount++;
        }
    }

    $API->disconnect();
}

// urutkan online dulu
usort($apData, function($a, $b) {
    return strcmp($a['status'], $b['status']);
});

// filter pencarian
$searchKeyword = isset($_GET['search']) ? trim($_GET['search']) : '';
if ($searchKeyword !== '') {
    $apData = array_filter($apData, function($ap) use ($searchKeyword) {
        return stripos($ap['name'], $searchKeyword) !== false;
    });
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>BANTANI - MONITORING PELANGGAN</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
</head>
<body class="dark-mode">
<div class="container">
    <div class="form-container">
        <h2>--- POP BAKAUHENI ---</h2>
        <div style="display: flex; align-items: center; justify-content: center; gap: 0;">
            <div class="kotak">
                <div class="active-users-count"><?php echo $activeUsers; ?></div>
                <div class="active-users-label">Voucher Online</div>
            </div>
            <div class="kotak2">
                <div class="up-ap-count"><?php echo $activeAPCount; ?></div>
                <div class="up-ap-label">Pelanggan On</div>
            </div>
            <div class="kotak3">
                <div class="down-ap-count"><?php echo $inactiveAPCount; ?></div>
                <div class="down-ap-label">Pelanggan Off</div>
            </div>
            <div class="kotak4">
                <div class="cpu-status-count"><?php echo $cpuStatus; ?>%</div>
                <div class="cpu-status-label">Cpu Mikrotik</div>
            </div>
        </div>
    </div>

    <!-- Form pencarian -->
    <div class="form-container" style="margin-top: 20px; text-align: center;">
    <form method="get" action="" style="display: inline-flex; align-items: center; gap: 8px;">
        <input type="text" name="search" 
               placeholder="Cari nama pelanggan..." 
               value="<?= htmlspecialchars($searchKeyword) ?>" 
               style="width: 300px; height: 50px; font-size: 16px; border-radius: 6px; border: none; outline: none; padding: 0 15px; box-sizing: border-box;">
        
        <button type="submit" 
                style="width: 90px; height: 50px; font-size: 16px; background-color: #28a745; color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: bold;">
            Cari
        </button>

        <?php if ($searchKeyword !== ''): ?>
            <a href="index.php" 
               style="display: inline-block; text-align: center; width: 90px; height: 50px; line-height: 50px; font-size: 16px; background-color: #dc3545; color: white; border-radius: 6px; text-decoration: none; font-weight: bold;">
                Reset
            </a>
        <?php endif; ?>
    </form>
</div>



    <div class="table-container">
        <h1>Daftar Pelanggan</h1>
        <?php if (!empty($apData)) { ?>
            <table>
                <thead>
                    <tr>
                        <th>Nama Pelanggan</th>
                        <th>Alamat IP</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($apData as $ap) { ?>
                        <tr>
                            <td><?php echo $ap['name']; ?></td>
                            <td><a style="color: white;" href="http://<?= $ap['ip']; ?>" target="_blank"><?= $ap['ip']; ?></a></td>
                            <td class="<?php echo ($ap['status'] == 'Online') ? 'status-up' : 'status-down'; ?>"><?php echo $ap['status']; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        <?php } else { ?>
            <p class="no-data">Tidak ada data yang cocok dengan pencarian.</p>
        <?php } ?>
    </div>
</div>

<button onclick="scrollToTop()" id="toTopBtn" style="display: none; position: fixed; bottom: 80px; right: 40px; z-index: 99; background-color: #000; color: white; border: none; padding: 25px 30px; font-size: 24px; border-radius: 12px; cursor: pointer;">
    ↑ Ke Atas
</button>

<script>
    window.onscroll = function () {
        var btn = document.getElementById("toTopBtn");
        if (document.body.scrollTop > 200 || document.documentElement.scrollTop > 200) {
            btn.style.display = "block";
        } else {
            btn.style.display = "none";
        }
    };
    function scrollToTop() {
        window.scrollTo({ top: 0, behavior: "smooth" });
    }
</script>
</body>
</html>
