<?php

require('routeros_api.class.php');
require('mikrotik_profil.php');

$API = new RouterosAPI();

$API->debug = false;

function addIPToMonitoring($API, $ip, $comment) {
    $API->write('/tool/netwatch/add', false);
    $API->write('=host=' . $ip);
    $API->write('=interval=10s');
    $API->write('=timeout=5s');
    $API->write('=down-script=/:log info message=("Host " . $host . " is down")');
    $API->write('=up-script=/:log info message=("Host " . $host . " is up")');
    $API->write('=comment=' . $comment);
    $API->read();
}

function getActiveHotspotUsers($API) {
    $API->write('/ip/hotspot/active/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);

    return count($ARRAY);
}

function deleteIPFromMonitoring($API, $id) {
    $API->write('/tool/netwatch/remove', false);
    $API->write('=numbers=' . $id);
    $API->read();
}

function getCPUStatus($API) {
    $API->write('/system/resource/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);

    if (!empty($ARRAY)) {
        return $ARRAY[0]['cpu-load'];
    } else {
        return 'N/A';
    }
}

$apData = array();
$activeAPCount = 0;
$inactiveAPCount = 0;

if ($API->connect($ipMikrotik, $username, $password)) {
    $API->write('/tool/netwatch/print');
    $READ = $API->read(false);
    $ARRAY = $API->parseResponse($READ);

    $activeUsers = getActiveHotspotUsers($API);
    $cpuStatus = getCPUStatus($API);

    foreach ($ARRAY as $item) {
        $name = (!empty($item['comment'])) ? $item['comment'] : 'Nama AP belum diisikan';

        $apData[] = array(
            'name' => $name,
            'ip' => $item['host'],
            'status' => ($item['status'] == 'up') ? 'On' : 'Off'
        );
    }

    foreach ($ARRAY as $item) {
        $name = (!empty($item['comment'])) ? $item['comment'] : 'Nama AP belum diisikan';

        if ($item['status'] == 'up') {
            $activeAPCount++;
        } else {
            $inactiveAPCount++;
        }
    }

    $API->disconnect();
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>NetworkSentinel - MONITORING JARINGAN</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
<!-- Untuk matikan Load otomatis pada halamannya bisa hapus tag script ini -->
    <script>
        setInterval(function() {
            location.reload();
        }, 5000);
    </script>
<!-- sampai disini -->
</head>
<body class="dark-mode">
    <div class="container">
        <div class="form-container">
    <!-- Nama "NetworkSentinel" Tolong Jangan diubah-ubah -->
            <h2>--- NetworkSentinel ---</h2>
            <div class="kotak">
                <div class="active-users-count"><?php echo $activeUsers; ?></div>
                <div class="active-users-label">Hotspot Online</div>
            </div>
            <div class="kotak2">
                <div class="up-ap-count"><?php echo $activeAPCount; ?></div>
                <div class="up-ap-label">AP On</div>
            </div>
            <div class="kotak3">
                <div class="down-ap-count"><?php echo $inactiveAPCount; ?></div>
                <div class="down-ap-label">AP Off</div>
            </div>
            <div class="kotak4">
                <div class="cpu-status-count"><?php echo $cpuStatus; ?>%</div>
                <div class="cpu-status-label">Cpu</div>
            </div>
        </div>
        <div class="table-container">
            <h1>Daftar Akses Poin</h1>
            <?php if (!empty($apData)) { ?>
                <table>
                    <thead>
                        <tr>
                            <th>Nama AP</th>
                            <th>Alamat IP</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($apData as $ap) { ?>
                            <tr>
                                <td><?php echo $ap['name']; ?></td>
                                <td><?php echo $ap['ip']; ?></td>
                                <td class="<?php echo ($ap['status'] == 'On') ? 'status-up' : 'status-down'; ?>"><?php echo $ap['status']; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            <?php } else { ?>
                <p class="no-data">Tidak ada data yang ditemukan.</p>
            <?php } ?>
        </div>
    </div>
</body>
</html>

    <!-- Nama "NetworkSentinel" Tolong Jangan diubah-ubah -->
